function output=qvdelayfit2exp(time,data,fitStart)
%This fits a double exponential to the gating data. It is called by
%gatingwrapper

%--------------------------------------------------------------------------
% Declare exclusion region

fitExclusion=1:fitStart-1;

%--------------------------------------------------------------------------

%close all;
%declare fit function to use
fitfunc=fittype('a1*exp(-x/b1)+a2*exp(-x/b2)+c');
%%%%%Set options here for the exponential fit (constraints, number of times to evaluate it, tolerance of difference between evaluations)%%%%
%This can be unhardcoded as well, and it would be nice if it could allow
%the user to switch the fit constraint options easily based on whether the gating current
%was from an activation or deactivation protocol
options=fitoptions(fitfunc);
options=fitoptions(options,'MaxIter',10000,'MaxFunEvals',10000,'TolFun',1e-16,'TolX',1e-16);

%fit bleaching curves and subtract from data; normalize resulting data
fittaus=zeros(size(data,2),2);
ampfracs=zeros(size(data,2),2);
fitzeros=zeros(size(data,2),1);
for n=1:size(data,2)
    %Provide data to exclude from fitting based on fitExclusion above (this
    %can be unhardcoded)
    exclusions=excludedata(time,data(:,n),'indices',fitExclusion);
    options=fitoptions(options,'Exclude',exclusions,'StartPoint',[-mean(data(:,n)),-mean(data(:,n)),mean(time),.05*mean(time),data(end,n)]);

    %The if statement below looks at the data between points 500 and 505
    %and determines which directions the fluorescence is going in. It would
    %be nice to have the user select whether their fluorescence traces were
    %going upwards or downwards and have the fit constraints vary to match.
    %if(mean(data(:,n))>0) %for on fits
    if(mean(data(500:505,n))<0) %for off fits
        options=fitoptions(options,'Lower',[-Inf,-Inf,0,0,-Inf],'Upper',[0,0,1000,1000,Inf]);
    else
        options=fitoptions(options,'Lower',[0,0,0,0,-Inf],'Upper',[Inf,Inf,1000,1000,Inf]);
    end
    %Fit the double exponential to the data
    zerofit=fit(time,data(:,n),fitfunc,options);
    %Assign the coefficients of each exponential to tau1 and tau2
    coeffs=coeffvalues(zerofit);
    tau1=coeffs(3);
    tau2=coeffs(4);
    %Determine the ampfrac of each exponential from the coefficients of the
    %fits, and assign to ampfrac1 and 2
    ampfrac1=coeffs(1)/(coeffs(1)+coeffs(2));
    ampfrac2=coeffs(2)/(coeffs(1)+coeffs(2));
    %Assign time constant and fractional amplitude to arrays fittaus and
    %ampfracs. The if statement is present to ensure that the fast time
    %constant is always placed first.
    if tau1<=tau2
        fittaus(n,1)=tau1;
        fittaus(n,2)=tau2;
        ampfracs(n,1)=ampfrac1;
        ampfracs(n,2)=ampfrac2;
    else
        fittaus(n,1)=tau2;
        fittaus(n,2)=tau1;
        ampfracs(n,1)=ampfrac2;
        ampfracs(n,2)=ampfrac1;
    end
    figure;
    plot(zerofit,time,data(:,n));
    %Code below can be uncommented to fit the delay prior to fluorescence
    %onset
    %[x0,~,flag]=fzero(zerofit,time(fitExclusion(end)));
    %if(flag~=1)
    %disp(['Curve ' num2str(n) ' fit error: curve does not cross 0 or zero cannot be found.']);
    %fitzeros(n)=NaN;
    %continue;
    %end
    %fitzeros(n)=x0;
end
output=[fitzeros,fittaus,ampfracs];